﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;

namespace Reversi
{
    public partial class Form1 : Form
    {
        private Button[,] plansza = new Button[ReversiSilnik.planszaSzer, ReversiSilnik.planszaWys];
        private ReversiSilnik silnik = new ReversiSilnik(1);

        private Color[] kolory = { Color.Ivory, Color.Green, Color.Sienna };

        private bool PlanszaZainicjowana
        {
            get
            {
                return plansza[ReversiSilnik.planszaSzer - 1, ReversiSilnik.planszaWys - 1] != null;
            }
        }

        private void dopasujRozmiarPlanszy()
        {
            if (!PlanszaZainicjowana) return;

            Rectangle rozmiarOkna = this.ClientRectangle;

            //ustalanie rozmiaru przycisku
            int rozmiarPlanszy = Math.Min(rozmiarOkna.Width, rozmiarOkna.Height);
            int przyciskSzer = rozmiarPlanszy / ReversiSilnik.planszaSzer;
            int przyciskWys = rozmiarPlanszy / ReversiSilnik.planszaWys;

            //ustalanie pozycji przycisku
            for (int i = 0; i < ReversiSilnik.planszaSzer; i++)
                for (int j = 0; j < ReversiSilnik.planszaWys; j++)
                    plansza[i, j].Bounds = new Rectangle(i * przyciskSzer, 1 + j * przyciskWys, przyciskSzer, przyciskWys);
        }

        private void uzgodnijZawartoscPlanszy()
        {
            if (!PlanszaZainicjowana) return;

            for (int i = 0; i < ReversiSilnik.planszaSzer; i++)
                for (int j = 0; j < ReversiSilnik.planszaWys; j++)
                {                    
                    //plansza[i, j].Text = silnik.StanPola(i, j).ToString();
                    plansza[i, j].BackColor = kolory[silnik.StanPola(i, j)];
                    //plansza[i, j].Text = silnik.PolozKamien(i, j, true).ToString();
                }

            button1.BackColor = kolory[silnik.NumerGraczaWykonujacegoNastepnyRuch];
            label1.Text = silnik.IloscPolGracz1.ToString();
            label2.Text = silnik.IloscPolGracz2.ToString();
        }

        public Form1()
        {
            InitializeComponent();            

            //ustalanie rozmiaru przycisku
            int przyciskSzer = this.ClientSize.Width / ReversiSilnik.planszaSzer;
            int przyciskWys = this.ClientSize.Height / ReversiSilnik.planszaWys;

            //tworzenie przyciskow
            for (int i = 0; i < ReversiSilnik.planszaSzer; i++)
                for (int j = 0; j < ReversiSilnik.planszaWys; j++)
                {
                    plansza[i, j] = new Button();
                    plansza[i, j].Parent = this;
                    plansza[i, j].Click += new EventHandler(kliknieciePolaPlanszy);
                }

            dopasujRozmiarPlanszy();
            uzgodnijZawartoscPlanszy();
            dopasujRozmiarPanelu();

            //test
            //silnik.PolozKamien(2, 4);
            //uzgodnijZawartoscPlanszy();
        }

        bool koniecGry = false;
        string[] nazwyGraczy = { "", "zielony", "brązowy" };

        void kliknieciePolaPlanszy(object sender, EventArgs e)
        {
            if (koniecGry) return;

            //szukamy pola planszy odpowiadającego kliknietemu przyciskowi
            int kliknietePoziomo = -1, kliknietePionowo = -1;
            for (int i = 0; i < ReversiSilnik.planszaSzer; i++)
                for (int j = 0; j < ReversiSilnik.planszaWys; j++)
                    if (sender == plansza[i, j])
                    {
                        kliknietePoziomo = i;
                        kliknietePionowo = j;
                    }

            //jezeli nie znaleziony - zglaszanie bledu
            if (kliknietePoziomo == -1 || kliknietePionowo == -1)
                throw new Exception("Nie zidentyfikowane pole planszy");

            //w przeciwnym razie - wykonanie ruchu
            int zapamietanyNumerGracza = silnik.NumerGraczaWykonujacegoNastepnyRuch;
            if (silnik.PolozKamien(kliknietePoziomo, kliknietePionowo))
            {
                uzgodnijZawartoscPlanszy();

                //lista ruchow
                switch (zapamietanyNumerGracza)
                {
                    case 1: listBox1.Items.Add(SymbolPola(kliknietePoziomo, kliknietePionowo)); break;
                    case 2: listBox2.Items.Add(SymbolPola(kliknietePoziomo, kliknietePionowo)); break;
                }
                listBox1.SelectedIndex = listBox1.Items.Count - 1;
                listBox2.SelectedIndex = listBox2.Items.Count - 1;

                //sytuacje specjalne
                ReversiSilnik.SytuacjeNaPlanszy sytuacjaNaPlanszy = silnik.ZbadajSytuacjeNaPlanszy();
                switch (sytuacjaNaPlanszy)
                {
                    case ReversiSilnik.SytuacjeNaPlanszy.BiezacyGraczNieMozeWykonacRuchu:
                        MessageBox.Show("Gracz " + nazwyGraczy[silnik.NumerGraczaWykonujacegoNastepnyRuch] + " zmuszony jest do oddania ruchu");
                        silnik.Pasuj();
                        uzgodnijZawartoscPlanszy();
                        break;
                    case ReversiSilnik.SytuacjeNaPlanszy.ObajGraczeNieMogaWykonacRuchu:
                        MessageBox.Show("Obaj gracze nie mogą wykonać ruchu");
                        koniecGry = true;
                        break;
                    case ReversiSilnik.SytuacjeNaPlanszy.WszystkiePolaPlanszySaZajete:
                        koniecGry = true;
                        break;
                }

                //wylonienie zwyciezcy
                if (koniecGry)
                {
                    int numerZwyciezcy = (silnik.IloscPolGracz1 > silnik.IloscPolGracz2) ? 1 : 2;
                    if (silnik.IloscPolGracz1 == silnik.IloscPolGracz2) numerZwyciezcy = 0;
                    if (numerZwyciezcy != 0) MessageBox.Show("Wygrał gracz " + nazwyGraczy[numerZwyciezcy]);
                    else MessageBox.Show("Remis");
                    if (MessageBox.Show("Czy rozpocząć grę od nowa?", "Reversi", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button1) == DialogResult.Yes)
                    {
                        koniecGry = false;
                        przygotowaniePlanszyDoNowejGry();                        
                    }
                }
            }
        }

        private void przygotowaniePlanszyDoNowejGry()
        {
            silnik = new ReversiSilnik(1); //stary obiekt zostanie automatycznie usuniety
            listBox1.Items.Clear();
            listBox2.Items.Clear();
            uzgodnijZawartoscPlanszy();
        }

        #region Obsluga Panelu        

        private bool panelZminimalizowany = true;

        static string katalogAplikacji
        {
            get
            {
                string katalog = Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().GetName().CodeBase);
                if (katalog.StartsWith("file:")) katalog = katalog.Remove(0, 6);
                return katalog;
            }
        }
        
        Bitmap obrazDoGory = new Bitmap(Path.Combine(katalogAplikacji,@"Obrazy\DoGory.png"));
        Bitmap obrazWDol = new Bitmap(Path.Combine(katalogAplikacji,@"Obrazy\WDol.png"));
        Bitmap obrazWLewo = new Bitmap(Path.Combine(katalogAplikacji,@"Obrazy\WLewo.png"));
        Bitmap obrazWPrawo = new Bitmap(Path.Combine(katalogAplikacji,@"Obrazy\WPrawo.png"));                
        
        private void dopasujRozmiarPanelu()
        {            
            if (!PlanszaZainicjowana) return;

            Rectangle rozmiarOkna=this.ClientRectangle;
            bool panelPionowy = rozmiarOkna.Width < rozmiarOkna.Height;

            //przycisk w lewym gornym rogu panelu
            button1.Left = 3;
            button1.Top = 3;
            button1.Width = 24;
            button1.Height = 20;

            pictureBox1.Visible = false;

            if (panelPionowy) //okno pionowe
            {
                panel1.Width = rozmiarOkna.Width;

                label3.Top = 5; label3.Left = 43; label3.Text = "Zielony"; //etykieta "Zielony"
                label1.Top = 5; label1.Left = 93;
                label4.Top = 5; label4.Left = 118; label4.Text = "Brązowy"; //etykieta "Brązowy"
                label2.Top = 5; label2.Left = 181;

                pictureBox1.Top = 4;
                pictureBox1.Left = panel1.Width - (int)(1.2 * pictureBox1.Width);

                if (panelZminimalizowany)
                {
                    //panel zminimalizowany z prawej strony planszy
                    Button dolnyPrzycisk = plansza[ReversiSilnik.planszaSzer - 1, ReversiSilnik.planszaWys - 1];
                    int dolnaKrawedzPlanszy = dolnyPrzycisk.Top + dolnyPrzycisk.Height;
                    panel1.Height = rozmiarOkna.Height - dolnaKrawedzPlanszy;
                    panel1.Top = dolnaKrawedzPlanszy;
                    panel1.Left = 0;
                    panel1.Width = rozmiarOkna.Width;

                    if (panel1.Height < 150)
                    {
                        pictureBox1.Image = obrazDoGory;
                        pictureBox1.Visible = true;
                    }
                }
                else
                {
                    //panel powiekszony z prawej strony planszy
                    panel1.Width = rozmiarOkna.Width;
                    panel1.Top = 150;
                    panel1.Height = rozmiarOkna.Height - panel1.Top;
                    panel1.Left = 0;

                    pictureBox1.Image = obrazWDol;
                    pictureBox1.Visible = true;
                }

                int h = 2 * button1.Top + button1.Height;
                if (panel1.Height > 2 * h)
                {
                    listBox1.Visible = true;
                    listBox2.Visible = true;

                    listBox1.Left = label3.Left;
                    listBox1.Top = h;
                    listBox1.Height = panel1.Height - listBox1.Top - h / 2;
                    listBox2.Left = label4.Left;
                    listBox2.Top = listBox1.Top;
                    listBox2.Height = listBox1.Height;
                    listBox1.Width = 66;
                    listBox2.Width = listBox1.Width;
                }
                else
                {
                    listBox1.Visible = false;
                    listBox2.Visible = false;
                }
            }
            else //okno poziome
            {
                int szerokoscPaneluPowiekszonego = 150;
                panel1.Height = rozmiarOkna.Height;

                label3.Left = 5; label3.Top = 43; label3.Text = "Ziel."; //etykieta "Zielony"
                label1.Left = 5; label1.Top = label3.Top + 20;
                int dolnaKrawedzPrzycisku = button1.Top + button1.Height;
                label4.Left = 5; label4.Top = dolnaKrawedzPrzycisku + (panel1.Height - (dolnaKrawedzPrzycisku)) / 2; label4.Text = "Brąz."; //etykieta "Brązowy"
                label2.Left = 5; label2.Top = label4.Top + 20;

                pictureBox1.Left = 5;
                pictureBox1.Top = panel1.Height - (int)(1.2 * pictureBox1.Height);

                if (panelZminimalizowany)
                {
                    //panel zminimalizowany pod planszą
                    Button prawyPrzycisk = plansza[ReversiSilnik.planszaSzer - 1, ReversiSilnik.planszaWys - 1];
                    int prawaKrawedzPlanszy = prawyPrzycisk.Left + prawyPrzycisk.Width;
                    panel1.Width = rozmiarOkna.Width - prawaKrawedzPlanszy;
                    panel1.Left = prawaKrawedzPlanszy;
                    panel1.Top = 0;

                    if (panel1.Width < szerokoscPaneluPowiekszonego)
                    {
                        pictureBox1.Image = obrazWLewo;
                        pictureBox1.Visible = true;
                    }
                }
                else
                {
                    //panel powiekszony pod planszą
                    panel1.Left = rozmiarOkna.Width - szerokoscPaneluPowiekszonego;
                    panel1.Width = rozmiarOkna.Width - panel1.Left;
                    panel1.Height = rozmiarOkna.Height;
                    panel1.Top = 0;

                    pictureBox1.Image = obrazWPrawo;
                    pictureBox1.Visible = true;
                }

                int h = 2 * button1.Top + button1.Height;
                int w = 2 * button1.Left + button1.Width;
                if (panel1.Height > 2 * h && panel1.Width > 3 * w)
                {
                    listBox1.Visible = true;
                    listBox2.Visible = true;

                    listBox1.Left = (int)(1.5 * w);
                    listBox1.Top = label3.Top;
                    listBox2.Left = listBox1.Left;
                    listBox2.Top = label4.Top;

                    listBox1.Height = listBox2.Top - listBox1.Top - h / 2;
                    listBox2.Height = listBox1.Height;
                    listBox1.Width = panel1.Width - listBox1.Left - w / 2;
                    listBox2.Width = listBox1.Width;
                }
                else
                {
                    listBox1.Visible = false;
                    listBox2.Visible = false;
                }
            }
        }
        #endregion

        private void Form1_Resize(object sender, EventArgs e)
        {
            if (PlanszaZainicjowana)
            {
                dopasujRozmiarPlanszy();
                dopasujRozmiarPanelu();
            }
        }

        private void pictureBox1_Click(object sender, EventArgs e)
        {
            panelZminimalizowany = !panelZminimalizowany;
            dopasujRozmiarPanelu();
        }

        public static string SymbolPola(int poziomo, int pionowo)
        {
            if (poziomo > 25 || pionowo > 8) return "(" + poziomo.ToString() + "," + pionowo.ToString() + ")";
            return "" + "ABCDEFGHIJKLMNOPQRSTUVWXYZ"[poziomo] + "123456789"[pionowo];
        }
    }
}